from flask.ext.admin._compat import iteritems
from flask.ext.admin.form import rules
from flask.ext.admin.model.form import InlineBaseFormAdmin


class EmbeddedForm(InlineBaseFormAdmin):
    def __init__(self, **kwargs):
        super(EmbeddedForm, self).__init__(**kwargs)

        self._form_subdocuments = convert_subdocuments(getattr(self, 'form_subdocuments', {}))

        form_rules = getattr(self, 'form_rules', None)

        if form_rules:
            self._form_rules = rules.RuleSet(self, form_rules)
        else:
            self._form_rules = None


def convert_subdocuments(values):
    result = {}

    for name, p in iteritems(values):
        if isinstance(p, dict):
            result[name] = EmbeddedForm(**p)
        elif isinstance(p, EmbeddedForm):
            result[name] = p
        else:
            raise ValueError('Invalid subdocument type: expecting dict or instance of flask.ext.admin.contrib.mongoengine.EmbeddedForm, got %s' % type(p))

    return result
